<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

$content = file_get_contents("php://input");
$update = json_decode($content, true);

include('class/bot.php');
include('class/db.php');

$bot = new bot("7923520128:AAEdPrqV2652P5y_4LTOXBSW-C-wfP-FvaA", $content);
$db = new db();

$db->getinfo($bot->chatid, $bot->username, $bot->firstname, $bot->lastname);

if ($bot->recmsg == "/start" || $bot->recmsg == "🔙 بازگشت") {
    $text = "به ربات املاک صنعتی اتون خوش آمدید
لطفا بر اساس درخواست خودتان یکی از موارد زیر را انتخاب نمایید
";

    $bot->sendmessage(urlencode($text), $bot->chatid, $bot->mainKey);
    
    $sql = "update users set req1='', req2='' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
} 

elseif($bot->recmsg == "register_property"){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("ثبت ملک جهت اجاره"),
                        "callback_data" => urlencode("ثبت ملک جهت اجاره")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("ثبت ملک جهت فروش"),
                        "callback_data" => urlencode("ثبت ملک جهت فروش")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $bot->sendmessage(urlencode('لطفا بر اساس درخواست خودتان یکی از موارد زیر را انتخاب نمایید'), $bot->chatid, $keys);
    $sql = "update users set req1='getDealType' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
}

elseif($bot->recmsg == "colleague_register"){
    $sql = "SELECT * FROM colleagues WHERE chatid = :chatid";
    $stmt = $db->conn->prepare($sql);
    $stmt->execute(['chatid' => $bot->chatid]);
    $colleague = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($colleague) {
        // نمایش اطلاعات فعلی و گزینه ویرایش
        $text = "اطلاعات شما:\nآدرس: " . $colleague['address'] . "\nشماره: " . $colleague['phone'] . "\n\nبرای ادامه ثبت ملک، گزینه مورد نظر را انتخاب کنید یا اطلاعات را ویرایش کنید.";
        $keys = json_encode(
            array(
                "inline_keyboard" => array(
                    array(
                        array(
                            "text" => urlencode("ثبت ملک جهت اجاره"),
                            "callback_data" => urlencode("ثبت ملک جهت اجاره")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("ثبت ملک جهت فروش"),
                            "callback_data" => urlencode("ثبت ملک جهت فروش")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("✏️ ویرایش اطلاعات همکار"),
                            "callback_data" => urlencode("edit_colleague_info")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("🔙 بازگشت"),
                            "callback_data" => urlencode("🔙 بازگشت")
                        )
                    )
                )
            )
        );
        $bot->sendmessage(urlencode($text), $bot->chatid, $keys);
        $sql = "UPDATE users SET req1='getDealType', req2='colleague' WHERE chatid='" . $bot->chatid . "'";
        $db->conn->exec($sql);
    } else {
        // درخواست اطلاعات همکار
        $text = "همکار گرامی لطفا آدرس ، نام دفتر و شماره تلفنتان را بصورت زیر وارد کنید\n\nمثال:\nآدرس:مشهد،بین پیامبر اعظم 73 و 75 املاک سالار\nشماره: 09158041534";
        $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);
        $sql = "UPDATE users SET req1='get_colleague_info' WHERE chatid='" . $bot->chatid . "'";
        $db->conn->exec($sql);
    }
}

elseif($bot->recmsg == "edit_colleague_info"){
    $text = "لطفاً آدرس و شماره جدید را وارد کنید:\n\nمثال:\nآدرس: تهران، خیابان آزادی\nشماره: 09123456789";
    $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);
    $sql = "UPDATE users SET req1='get_colleague_info' WHERE chatid='" . $bot->chatid . "'";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'get_colleague_info'){
    // جدا کردن آدرس و شماره
    $input = $bot->recmsg;
    $lines = explode("\n", $input);
    $address = '';
    $phone = '';
    
    foreach($lines as $line){
        if(strpos($line, 'آدرس:') !== false){
            $address = trim(str_replace('آدرس:', '', $line));
        }
        elseif(strpos($line, 'شماره:') !== false){
            $phone = trim(str_replace('شماره:', '', $line));
        }
    }
    
    // اعتبارسنجی شماره تلفن
    $persian_digits = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $english_digits = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    $phone = str_replace($persian_digits, $english_digits, $phone);
    
    if (!preg_match('/^09[0-9]{9}$/', $phone) || empty($address)) {
        $text = "❌ اطلاعات ناقص یا نامعتبر است. لطفاً آدرس و شماره تلفن را به فرمت زیر وارد کنید:\n\nآدرس: [آدرس شما]\nشماره: 09XXXXXXXXX";
        $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);
        exit();
    }
    
    // چک کردن وضعیت قبل از هر تغییری در دیتابیس
    $sql = "SELECT COUNT(*) FROM colleagues WHERE chatid = :chatid";
    $stmt = $db->conn->prepare($sql);
    $stmt->execute(['chatid' => $bot->chatid]);
    $is_existing = $stmt->fetchColumn() > 0;

    // ذخیره اطلاعات در جدول colleagues
    $sql = "INSERT INTO colleagues (chatid, address, phone) VALUES (:chatid, :address, :phone) 
            ON DUPLICATE KEY UPDATE address = :address, phone = :phone";
    $stmt = $db->conn->prepare($sql);
    $stmt->execute(['chatid' => $bot->chatid, 'address' => $address, 'phone' => $phone]);
    
    // گرفتن اطلاعات به‌روز شده از دیتابیس برای تأیید
    $sql = "SELECT address, phone FROM colleagues WHERE chatid = :chatid";
    $stmt = $db->conn->prepare($sql);
    $stmt->execute(['chatid' => $bot->chatid]);
    $colleague = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // پیام تأیید به کاربر بر اساس ثبت یا ویرایش
    $text = $is_existing 
        ? "✅ اطلاعات شما با موفقیت تغییر کرد:\nآدرس: " . $colleague['address'] . "\nشماره: " . $colleague['phone'] . "\n\nبرای ادامه، گزینه مورد نظر را انتخاب کنید:"
        : "✅ اطلاعات شما با موفقیت ثبت شد:\nآدرس: " . $colleague['address'] . "\nشماره: " . $colleague['phone'] . "\n\nبرای ادامه، گزینه مورد نظر را انتخاب کنید:";
    
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("ثبت ملک جهت اجاره"),
                        "callback_data" => urlencode("ثبت ملک جهت اجاره")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("ثبت ملک جهت فروش"),
                        "callback_data" => urlencode("ثبت ملک جهت فروش")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);
    
    // به‌روزرسانی وضعیت کاربر
    $sql = "UPDATE users SET req1='getDealType', req2='colleague' WHERE chatid=:chatid";
    $stmt = $db->conn->prepare($sql);
    $stmt->execute(['chatid' => $bot->chatid]);
}

elseif($db->req1 == 'getDealType'){
    if($bot->recmsg == "ثبت ملک جهت اجاره"){
        $keys = json_encode(
            array(
                "inline_keyboard" => array(
                    array(
                        array(
                            "text" => urlencode("انبار"),
                            "callback_data" => urlencode("انبار")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("فعالیت صنعتی"),
                            "callback_data" => urlencode("فعالیت صنعتی")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("🔙 بازگشت"),
                            "callback_data" => urlencode("🔙 بازگشت")
                        )
                    )
                )
            )
        );
        
        $state = 'getRentType';
        $text = 'کاربری ملک خود انتخاب کنید';
    }
    elseif($bot->recmsg == "ثبت ملک جهت فروش"){
        $keys = json_encode(
            array(
                "inline_keyboard" => array(
                    array(
                        array(
                            "text" => urlencode("خارج از شهرک صنعتی"),
                            "callback_data" => urlencode("خارج از شهرک صنعتی")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("داخل شهرک صنعتی"),
                            "callback_data" => urlencode("داخل شهرک صنعتی")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("باغ و ویلا"),
                            "callback_data" => urlencode("باغ و ویلا")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("🔙 بازگشت"),
                            "callback_data" => urlencode("🔙 بازگشت")
                        )
                    )
                )
            )
        );
        
        $state = 'getSellType';
        $text = 'منطقه ی مورد نظر خود را انتخاب کنید';
    } else {
        $text = "لطفاً یکی از گزینه‌های معتبر (اجاره یا فروش) را انتخاب کنید.";
        $keys = json_encode(
            array(
                "inline_keyboard" => array(
                    array(
                        array(
                            "text" => urlencode("🔙 بازگشت"),
                            "callback_data" => urlencode("🔙 بازگشت")
                        )
                    )
                )
            )
        );
        $state = 'getDealType';
    }

    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);
    $sql = "update users set req1='$state' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
}

// Sell flow
elseif($db->req1 == 'getSellType'){
    if($bot->recmsg == "باغ و ویلا"){
        $text = "جهت ثبت باغ و ویلای خود اطلاعات کامل آن را به آیدی @amlaksalarii ارسال نمایید.";
        $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);
        
        $sql = "update users set req1='' where chatid='" . $bot->chatid . "' ";
        $db->conn->exec($sql);
    } else {
        $keys = json_encode(
            array(
                "inline_keyboard" => array(
                    array(
                        array(
                            "text" => urlencode("کمتر از 200 متر"),
                            "callback_data" => urlencode("کمتر از 200 متر")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("200 الی 500 متر"),
                            "callback_data" => urlencode("200 الی 500 متر")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("500 متر به بالا"),
                            "callback_data" => urlencode("500 متر به بالا")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("زمین"),
                            "callback_data" => urlencode("زمین")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("🔙 بازگشت"),
                            "callback_data" => urlencode("🔙 بازگشت")
                        )
                    )
                )
            )
        );
        
        $text = "متراژ مورد نظر خود را انتخاب کنید";
        $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

        $sql = "update users set req1='getMeterageSell', req2='$bot->recmsg' where chatid='" . $bot->chatid . "' ";
        $db->conn->exec($sql);
    }
}

elseif($db->req1 == 'getMeterageSell'){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("بدون دفتر"),
                        "callback_data" => urlencode("بدون دفتر")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $text = "متراژ دفتر کار را وارد کنید و درصورتی که فاقد دفترکار هست بر روی دکمه ی بدون دفتر کار کلیک کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

    $sql = "insert into sells (chatid, type, meterage) values ('$bot->chatid', '$db->req2', '$bot->recmsg')";
    $db->conn->exec($sql);

    $lastInsertedId = $db->conn->lastInsertId();
    $sql = "update users set req1='getDafterMeterageSell', req5='$lastInsertedId' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getDafterMeterageSell'){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("بدون محوطه"),
                        "callback_data" => urlencode("بدون محوطه")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $text = "متراژ محوطه را وارد کنید و درصورتی که فاقد محوطه هست بر روی دکمه ی بدون محوطه کلیک کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

    $sql = "update users set req1='getMohavateMeterageSell' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);

    $sql = "update `sells` set daftar='$bot->recmsg' where id='$db->req5' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getMohavateMeterageSell'){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("فاقد امتیاز"),
                        "callback_data" => urlencode("فاقد امتیاز")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $text = "در صورتی که ملک خود دارای امتیاز اب برق گاز و تلفن هست ان را بنویسید در غیر این صورت بر روی فاقد امتیاز کلیک کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

    $sql = "update users set req1='getEmtiazSell' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);

    $sql = "update `sells` set mohavate='$bot->recmsg' where id='$db->req5' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getEmtiazSell'){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("دارای پایانکار"),
                        "callback_data" => urlencode("دارای پایانکار")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("فاقد پایانکار"),
                        "callback_data" => urlencode("فاقد پایانکار")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );

    $text = "لطفا وضعیت پایانکار ملک خود را مشخص کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

    $sql = "update `sells` set emtiaz='$bot->recmsg' where id='$db->req5' ";
    $db->conn->exec($sql);

    $sql = "update users set req1='getPayanKar' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getPayanKar'){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("بدون توضیحات"),
                        "callback_data" => urlencode("بدون توضیحات")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $text = "توضیحات اضافی شامل (کاربری ملک ، متراژ کل و ...) را بنویسید در غیر اینصورت بر روی بدون توضیحات کلیک کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

    $sql = "update users set req1='getDescSell' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);

    $sql = "update `sells` set payankar='$bot->recmsg' where id='$db->req5' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getDescSell'){
    $text = "عکس اول مربوط به ملک خود را وارد کنید و درصورت عدم وجود روی بدون عکس کلیک کنید";

    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("بدون تصویر"),
                        "callback_data" => urlencode("بدون تصویر")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );

    $bot->sendmessage(urlencode($text), $bot->chatid, $keys); 

    $lastInsertedId = $db->conn->lastInsertId();
    $sql = "update users set req1='getFileSell', image_count=0, req6='$bot->recmsg' where chatid='" . $bot->chatid . "'";
    $db->conn->exec($sql);

    $sql = "update `sells` set description='$bot->recmsg' where id='$db->req5' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getFileSell'){
    if((isset($bot->recmsg) && !empty($bot->recmsg) || isset($update))){ 
        if(strtolower($bot->recmsg) == "اتمام تصاویر" || strtolower($bot->recmsg) == "بدون تصویر"){
            $text = "تصاویر شما ذخیره شدند. آدرس ملک خود را دقیق وارد کنید";
            $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);    
            
            $sql = "update users set req1='getAddressSell' where chatid='" . $bot->chatid . "'";
            $db->conn->exec($sql);
        } else {
            if (!isset($update["message"]["photo"])) {
                $keys = json_encode(
                    array(
                        "inline_keyboard" => array(
                            array(
                                array(
                                    "text" => urlencode("بدون تصویر"),
                                    "callback_data" => urlencode("بدون تصویر")
                                )
                            ),
                            array(
                                array(
                                    "text" => urlencode("🔙 بازگشت"),
                                    "callback_data" => urlencode("🔙 بازگشت")
                                )
                            )
                        )
                    )
                );
                
                $text = "❌ فایل ارسالی عکس نیست لطفا عکس ارسال کنید";
                $bot->sendmessage(urlencode($text), $bot->chatid, $keys);
                exit();
            }

            $stmt = $db->conn->query("SELECT image_count FROM users WHERE chatid='" . $bot->chatid . "'");
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $image_count = $result['image_count'];
            $message_id_counter = intval($image_count) + 1;

            if($image_count < 20){
                $keys = json_encode(
                    array(
                        "inline_keyboard" => array(
                            array(
                                array(
                                    "text" => urlencode("اتمام تصاویر"),
                                    "callback_data" => urlencode("اتمام تصاویر")
                                )
                            ),
                            array(
                                array(
                                    "text" => urlencode("🔙 بازگشت"),
                                    "callback_data" => urlencode("🔙 بازگشت")
                                )
                            )
                        )
                    )
                );
                
                $text = "تصویر " . ($image_count + 1) . " دریافت شد. لطفاً تصویر بعدی را ارسال کنید یا برای اتمام بر روی اتمام تصاویر کلیک کنید.";
                $bot->sendmessage(urlencode($text), $bot->chatid, $keys);    

                $sql = "UPDATE users SET image_count=image_count + 1 WHERE chatid='" . $bot->chatid . "'";
                $db->conn->exec($sql);
                $sql = "UPDATE sells SET message_id$message_id_counter='$bot->message_id' WHERE id='" . $db->req5 . "'";
                $db->conn->exec($sql);
            } else {
                $text = "شما حداکثر 20 تصویر را ارسال کرده‌اید. آدرس ملک خود را دقیق وارد کنید.";
                $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);    

                $sql = "update users set req1='getAddressSell' where chatid='" . $bot->chatid . "'";
                $db->conn->exec($sql);
            }
        }
    }
}

elseif($db->req1 == 'getAddressSell') {
    $text = "شماره تماس خود را وارد کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);    

    $sql = "update users set req1='getPhoneSell' where chatid='" . $bot->chatid . "'";
    $db->conn->exec($sql);

    $sql = "update sells set address='$bot->recmsg' where id='$db->req5' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getPhoneSell') {
    $phone = $bot->recmsg;

    $persian_digits = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $english_digits = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    $phone = str_replace($persian_digits, $english_digits, $phone);

    if (!preg_match('/^09[0-9]{9}$/', $phone)) {
        $text = "❌ شماره موبایل وارد شده معتبر نیست. لطفاً شماره‌ای معتبر با فرمت 09XXXXXXXXX وارد کنید.";
        $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);
        exit();
    }

    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("توافقی"),
                        "callback_data" => urlencode("توافقی")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );

    $text = "مبلغ پیشنهادی خود را وارد کنید یا بر روی توافقی کلیک کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);
    $sql = "UPDATE users SET req1='getPriceSell' WHERE chatid='" . $bot->chatid . "'";
    $db->conn->exec($sql);

    $sql = "update sells set phone='$phone' where id='$db->req5' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getPriceSell') {
    $price = $bot->recmsg;

    $sql = "SELECT * FROM colleagues WHERE chatid = :chatid";
    $stmt = $db->conn->prepare($sql);
    $stmt->execute(['chatid' => $bot->chatid]);
    $colleague = $stmt->fetch(PDO::FETCH_ASSOC);
    $colleague_info = $colleague ? "\nآدرس همکار: {$colleague['address']}\nشماره همکار: {$colleague['phone']}" : '';

    $result = $db->getSell($db->req5);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id1']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id2']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id3']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id4']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id5']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id6']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id7']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id8']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id9']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id10']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id11']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id12']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id13']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id14']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id15']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id16']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id17']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id18']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id19']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id20']);
    
    $text = "
مشخصات کاربر 
$db->telname
$db->username
$phone
$colleague_info
مشخصات ملک
نوع ملک :‌ $result[type]
متراژ : $result[meterage]
توضیحات: $result[description]
ابعاد محوطه : $result[mohavate]
ابعاد دفتر : $result[daftar]
امتیازات ملک : $result[emtiaz]
آدرس ملک : $result[address]
قیمت : $price
پایانکار : $result[payankar]
شماره : $result[phone] 

کاربر با مشخصات بالا قصد ارسال ثبت اگهی با این مشخصات را دارد در صورت تایید بر روی دکمه ی تایید کلیک کنید
";
    
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(array("callback_data" => urlencode("sellacc_".$bot->chatid."_$db->req5"), "text" => urlencode("تایید"))),
                array(array("callback_data" => urlencode("selldecl_".$bot->chatid."_$db->req5"), "text" => urlencode("رد"))),
            )
        )
    );
    
    $bot->sendmessage(urlencode($text), 231233081, $keys);    
    
    $text = "اطلاعات جهت تایید ادمین ارسال شدند. در صورت تایید در ربات در دسترس قرار می‌گیرند.";
    $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);    
    
    $sql = "UPDATE users SET req1='', req5='' WHERE chatid='" . $bot->chatid . "'";
    $db->conn->exec($sql);
    
    $sql = "UPDATE sells SET price='$price' WHERE id='" . $db->req5 . "'";
    $db->conn->exec($sql);
}

elseif(strpos($bot->recmsg,"sellacc_") !== false){
    $parts = explode('_', $bot->recmsg);
    $chatid = $parts[1]; 
    $id = $parts[2]; 

    $bot->sendmessage(urlencode('ملک تایید شد'), $chatid, $bot->backKey);
    $bot->sendmessage(urlencode('ملک تایید شد'), $bot->chatid, $bot->backKey);
    $sql = "update sells set `status`='accepted' where id='" . $id . "' ";
    $db->conn->exec($sql);
}

elseif(strpos($bot->recmsg,"selldecl_") !== false){
    $parts = explode('_', $bot->recmsg);
    $chatid = $parts[1]; 
    $id = $parts[2]; 

    $bot->sendmessage(urlencode('ملک رد شد'), $chatid, $bot->backKey);
    $bot->sendmessage(urlencode('ملک رد شد'), $bot->chatid, $bot->backKey);
    $sql = "update sells set `status`='rejected' where id='" . $id . "' ";
    $db->conn->exec($sql);
}

// Rent flow
elseif($db->req1 == 'getRentType'){
    if($bot->recmsg == "انبار"){
        $keys = json_encode(
            array(
                "inline_keyboard" => array(
                    array(
                        array(
                            "text" => urlencode("پخش دارو و بهداشتی"),
                            "callback_data" => urlencode("پخش دارو و بهداشتی")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("پخش مواد غذایی"),
                            "callback_data" => urlencode("پخش مواد غذایی")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("سایر انبارها"),
                            "callback_data" => urlencode("سایر انبارها")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("🔙 بازگشت"),
                            "callback_data" => urlencode("🔙 بازگشت")
                        )
                    )
                )
            )
        );
        
        $state = 'getWarehouseType';
        $text = "نوع انبار مد نظر خود را انتخاب کنید";
    }
    elseif($bot->recmsg == "فعالیت صنعتی"){
        $keys = json_encode(
            array(
                "inline_keyboard" => array(
                    array(
                        array(
                            "text" => urlencode("کمتر از 200 متر"),
                            "callback_data" => urlencode("کمتر از 200 متر")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("200 الی 500 متر"),
                            "callback_data" => urlencode("200 الی 500 متر")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("500 متر به بالا"),
                            "callback_data" => urlencode("500 متر به بالا")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("زمین"),
                            "callback_data" => urlencode("زمین")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("🔙 بازگشت"),
                            "callback_data" => urlencode("🔙 بازگشت")
                        )
                    )
                )
            )
        );
        
        $text = "متراژ ملک را انتخاب کنید";
        $state = 'getMeterage';
    }

    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);
    $sql = "update users set req1='$state', req2='$bot->recmsg' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getWarehouseType'){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("کمتر از 200 متر"),
                        "callback_data" => urlencode("کمتر از 200 متر")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("200 الی 500 متر"),
                        "callback_data" => urlencode("200 الی 500 متر")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("500 متر به بالا"),
                        "callback_data" => urlencode("500 متر به بالا")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("زمین"),
                        "callback_data" => urlencode("زمین")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $text = "متراژ سوله را وارد کنید و در صورتی که ملک سوله ندارد بر روی دکمه ی زمین کلیک کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

    $sql = "update users set req1='getMeterage', req3='$bot->recmsg' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getMeterage'){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("بدون دفترکار"),
                        "callback_data" => urlencode("بدون دفترکار")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $text = "متراژ دفتر کار را وارد کنید و درصورتی که فاقد دفترکار هست بر روی دکمه ی بدون دفتر کار کلیک کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

    if($db->req2 == 'انبار'){
        $sql = "insert into rents (chatid, type, rent_type, meterage) values ('$bot->chatid', '$db->req2', '$db->req3', '$bot->recmsg')";
    } elseif($db->req2 == 'فعالیت صنعتی'){
        $sql = "insert into rents (chatid, type, meterage) values ('$bot->chatid', '$db->req2', '$bot->recmsg')";
    }
    
    $db->conn->exec($sql);
    $lastInsertedId = $db->conn->lastInsertId();
    $sql = "update users set req1='getDafterMeterage', req5='$lastInsertedId' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getDafterMeterage'){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("بدون محوطه"),
                        "callback_data" => urlencode("بدون محوطه")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $text = "متراژ محوطه را وارد کنید و درصورتی که فاقد محوطه هست بر روی دکمه ی بدون محوطه کلیک کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

    $sql = "update users set req1='getMohavateMeterage' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);

    $sql = "update `rents` set daftar='$bot->recmsg' where id='$db->req5' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getMohavateMeterage'){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("فاقد امتیاز"),
                        "callback_data" => urlencode("فاقد امتیاز")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $text = "در صورتی که ملک خود دارای امتیاز اب برق گاز و تلفن هست ان را بنویسید در غیر این صورت بر روی فاقد امتیاز کلیک کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

    $sql = "update users set req1='getEmtiaz' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);

    $sql = "update `rents` set mohavate='$bot->recmsg' where id='$db->req5' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getEmtiaz'){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("بدون توضیحات"),
                        "callback_data" => urlencode("بدون توضیحات")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $text = "توضیحات اضافی شامل (کاربری ملک ، متراژ کل و ...) را بنویسید در غیر اینصورت بر روی بدون توضیحات کلیک کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

    $sql = "update users set req1='getDesc' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);

    $sql = "update `rents` set emtiaz='$bot->recmsg' where id='$db->req5' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getDesc'){
    $text = "عکس اول مربوط به ملک خود را وارد کنید و درصورت عدم وجود روی بدون عکس کلیک کنید";

    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("بدون تصویر"),
                        "callback_data" => urlencode("بدون تصویر")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);    

    $sql = "update users set req1='getFile', image_count=0, req6='$bot->recmsg' where chatid='" . $bot->chatid . "'";
    $db->conn->exec($sql);

    $sql = "update `rents` set description='$bot->recmsg' where id='$db->req5' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getFile'){
    if((isset($bot->recmsg) && !empty($bot->recmsg) || isset($update))){ 
        if(strtolower($bot->recmsg) == "اتمام تصاویر" || strtolower($bot->recmsg) == "بدون تصویر"){
            $text = "تصاویر شما ذخیره شدند. آدرس ملک خود را دقیق وارد کنید";
            $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);    
            
            $sql = "update users set req1='getAddress' where chatid='" . $bot->chatid . "'";
            $db->conn->exec($sql);
        } else {
            if (!isset($update["message"]["photo"])) {
                $keys = json_encode(
                    array(
                        "inline_keyboard" => array(
                            array(
                                array(
                                    "text" => urlencode("بدون تصویر"),
                                    "callback_data" => urlencode("بدون تصویر")
                                )
                            ),
                            array(
                                array(
                                    "text" => urlencode("🔙 بازگشت"),
                                    "callback_data" => urlencode("🔙 بازگشت")
                                )
                            )
                        )
                    )
                );
                
                $text = "❌ فایل ارسالی عکس نیست لطفا عکس ارسال کنید";
                $bot->sendmessage(urlencode($text), $bot->chatid, $keys);
                exit();
            }

            $stmt = $db->conn->query("SELECT image_count FROM users WHERE chatid='" . $bot->chatid . "'");
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $image_count = $result['image_count'];
            $message_id_counter = intval($image_count) + 1;

            if($image_count < 20){
                $keys = json_encode(
                    array(
                        "inline_keyboard" => array(
                            array(
                                array(
                                    "text" => urlencode("اتمام تصاویر"),
                                    "callback_data" => urlencode("اتمام تصاویر")
                                )
                            ),
                            array(
                                array(
                                    "text" => urlencode("🔙 بازگشت"),
                                    "callback_data" => urlencode("🔙 بازگشت")
                                )
                            )
                        )
                    )
                );
                
                $text = "تصویر " . ($image_count + 1) . " دریافت شد. لطفاً تصویر بعدی را ارسال کنید یا برای اتمام بر روی اتمام تصاویر کلیک کنید.";
                $bot->sendmessage(urlencode($text), $bot->chatid, $keys);    

                $sql = "UPDATE users SET image_count=image_count + 1 WHERE chatid='" . $bot->chatid . "'";
                $db->conn->exec($sql);
                $sql = "UPDATE rents SET message_id$message_id_counter='$bot->message_id' WHERE id='" . $db->req5 . "'";
                $db->conn->exec($sql);
            } else {
                $text = "شما حداکثر 20 تصویر را ارسال کرده‌اید. آدرس ملک خود را دقیق وارد کنید.";
                $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);    

                $sql = "update users set req1='getAddress' where chatid='" . $bot->chatid . "'";
                $db->conn->exec($sql);
            }
        }
    }
}

elseif($db->req1 == 'getAddress') {
    $text = "شماره تماس خود را وارد کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);    

    $sql = "update users set req1='getPhone' where chatid='" . $bot->chatid . "'";
    $db->conn->exec($sql);

    $sql = "update `rents` set address='$bot->recmsg' where id='$db->req5' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getPhone') {
    $phone = $bot->recmsg;

    $persian_digits = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $english_digits = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    $phone = str_replace($persian_digits, $english_digits, $phone);

    if (!preg_match('/^09[0-9]{9}$/', $phone)) {
        $text = "❌ شماره موبایل وارد شده معتبر نیست. لطفاً شماره‌ای معتبر با فرمت 09XXXXXXXXX وارد کنید.";
        $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);
        exit();
    }

    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("توافقی"),
                        "callback_data" => urlencode("توافقی")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );

    $text = "مبلغ پیشنهادی خود را وارد کنید یا بر روی توافقی کلیک کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);
    $sql = "UPDATE users SET req1='getPrice' WHERE chatid='" . $bot->chatid . "'";
    $db->conn->exec($sql);

    $sql = "update `rents` set phone='$bot->recmsg' where id='$db->req5' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'getPrice') {
    $sql = "SELECT * FROM colleagues WHERE chatid = :chatid";
    $stmt = $db->conn->prepare($sql);
    $stmt->execute(['chatid' => $bot->chatid]);
    $colleague = $stmt->fetch(PDO::FETCH_ASSOC);
    $colleague_info = $colleague ? "\nآدرس همکار: {$colleague['address']}\nشماره همکار: {$colleague['phone']}" : '';

    $result = $db->getRent($db->req5);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id1']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id2']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id3']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id4']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id5']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id6']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id7']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id8']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id9']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id10']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id11']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id12']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id13']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id14']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id15']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id16']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id17']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id18']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id19']);
    $bot->copyMessage(231233081, $result['chatid'], $result['message_id20']);
    
    $text = "
مشخصات کاربر 
$db->telname
$db->username
$phone
$colleague_info
مشخصات ملک
نوع ملک : $result[type]
کاربری ملک : $result[rent_type]
متراژ :‌ $result[meterage]
توضیحات : $result[description]
ابعاد محوطه : $result[mohavate]
ابعاد دفتر : $result[daftar]
امتیازات ملک : $result[emtiaz]
آدرس ملک : $result[address]
قیمت : $bot->recmsg
شماره : $result[phone]
کاربر با مشخصات بالا قصد ارسال ثبت اگهی با این مشخصات را دارد در صورت تایید بر روی دکمه ی تایید کلیک کنید
";

    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(array("callback_data" => ("accept_".$bot->chatid."_$db->req5"), "text" => urlencode("تایید"))),
                array(array("callback_data" => ("decline_".$bot->chatid."_$db->req5"), "text" => urlencode("رد"))),
            )
        )
    );

    $bot->sendmessage(urlencode($text), 231233081, $keys);    
    
    $text = "اطلاعات جهت تایید ادمین ارسال شدند. در صورت تایید در ربات در دسترس قرار می‌گیرند.";
    $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);    

    $sql = "UPDATE rents SET price='$bot->recmsg' WHERE id='" . $db->req5 . "'";
    $db->conn->exec($sql);

    $sql = "UPDATE users SET req1='', req5='' WHERE chatid='" . $bot->chatid . "'";
    $db->conn->exec($sql);
}

elseif(strpos($bot->recmsg,"accept_") !== false){
    $parts = explode('_', $bot->recmsg);
    $chatid = $parts[1]; 
    $id = $parts[2]; 

    $bot->sendmessage(urlencode('ملک تایید شد'), $chatid, $bot->backKey);
    $bot->sendmessage(urlencode('ملک تایید شد'), $bot->chatid, $bot->backKey);
    $sql = "update rents set `status`='accepted' where id='" . $id . "' ";
    $db->conn->exec($sql);
}

elseif(strpos($bot->recmsg,"decline_") !== false){
    $parts = explode('_', $bot->recmsg);
    $chatid = $parts[1]; 
    $id = $parts[2]; 

    $bot->sendmessage(urlencode('ملک رد شد'), $chatid, $bot->mainKey);
    $bot->sendmessage(urlencode('ملک رد شد'), $bot->chatid, $bot->mainKey);
    $sql = "update rents set `status`='rejected' where id='" . $id . "' ";
    $db->conn->exec($sql);
}

elseif($bot->recmsg == "request_rental"){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("انبار"),
                        "callback_data" => urlencode("انبار")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("فعالیت صنعتی"),
                        "callback_data" => urlencode("فعالیت صنعتی")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $text = "گزینه ی مورد نظر خود را انتخاب کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

    $sql = "update users set req1='rentShow', req2='' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'rentShow'){
    if($bot->recmsg == "انبار"){
        $keys = json_encode(
            array(
                "inline_keyboard" => array(
                    array(
                        array(
                            "text" => urlencode("پخش دارو و بهداشتی"),
                            "callback_data" => urlencode("پخش دارو و بهداشتی")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("پخش مواد غذایی"),
                            "callback_data" => urlencode("پخش مواد غذایی")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("سایر انبارها"),
                            "callback_data" => urlencode("سایر انبارها")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("🔙 بازگشت"),
                            "callback_data" => urlencode("🔙 بازگشت")
                        )
                    )
                )
            )
        );
        
        $state = 'showWarehouseType';
        $text = "نوع انبار مد نظر خود را انتخاب کنید";
    }
    elseif($bot->recmsg == "فعالیت صنعتی"){
        $keys = json_encode(
            array(
                "inline_keyboard" => array(
                    array(
                        array(
                            "text" => urlencode("کمتر از 200 متر"),
                            "callback_data" => urlencode("کمتر از 200 متر")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("200 الی 500 متر"),
                            "callback_data" => urlencode("200 الی 500 متر")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("500 متر به بالا"),
                            "callback_data" => urlencode("500 متر به بالا")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("زمین"),
                            "callback_data" => urlencode("زمین")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("🔙 بازگشت"),
                            "callback_data" => urlencode("🔙 بازگشت")
                        )
                    )
                )
            )
        );
        
        $text = "متراژ ملک را انتخاب کنید";
        $state = 'showMeterage';
    }

    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);
    $sql = "update users set req1='$state', req2='$bot->recmsg' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'showWarehouseType'){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("کمتر از 200 متر"),
                        "callback_data" => urlencode("کمتر از 200 متر")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("200 الی 500 متر"),
                        "callback_data" => urlencode("200 الی 500 متر")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("500 متر به بالا"),
                        "callback_data" => urlencode("500 متر به بالا")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("زمین"),
                        "callback_data" => urlencode("زمین")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $text = "متراژ ملک را انتخاب کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

    $sql = "update users set req1='showMeterage', req3='$bot->recmsg' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'showMeterage'){
    if($db->req2 == 'انبار'){
        $sql = "select * from rents where type='$db->req2' and meterage='$bot->recmsg' and rent_type='$db->req3' and `status`='accepted'";
        $stmt = $db->conn->prepare($sql);
        $stmt->execute();
        $stmt->setFetchMode(PDO::FETCH_ASSOC);
        $getter = $stmt->fetchAll();
        if (count($getter) == 0) {
            $bot->sendmessage(urlencode('ملکی یافت نشد'), $bot->chatid, $bot->backKey);
            exit();
        } 
    
        foreach($getter as $singleGetter){
            $text="
    کد ملک : $singleGetter[id]
    متراژ : $singleGetter[meterage]
    ملک : $singleGetter[type]
    کاربری : $singleGetter[rent_type]
    توضیحات: $singleGetter[description]
    ابعاد محوطه : $singleGetter[mohavate]
    ابعاد دفتر : $singleGetter[daftar]
    امتیازات ملک : $singleGetter[emtiaz]
    آدرس ملک : $singleGetter[address]
    قیمت : $singleGetter[price]
    
    برای مشاهده ی عکس های ملک بر روی مشاهده تصاویر کلیک کنید
    
    برای ارتباط با ادمین به آیدی @amlaksalarii پیام بدهید
            ";

            if(empty($singleGetter['message_id1'])){
                $keys = json_encode(
                    array(
                        "inline_keyboard" => array(
                            array(array("callback_data" => urlencode("🔙 بازگشت"), "text" => urlencode("🔙 بازگشت"))),
                        )
                    )
                );
            } else {
                $keys = json_encode(
                    array(
                        "inline_keyboard" => array(
                            array(array("callback_data" => urlencode("showRentPicWarehouse_"."$singleGetter[id]"), "text" => urlencode("مشاهده تصاویر"))),
                            array(array("callback_data" => urlencode("🔙 بازگشت"), "text" => urlencode("🔙 بازگشت"))),
                        )
                    )
                );
            }
    
            $bot->sendmessage(urlencode($text), $bot->chatid, $keys);
        }
    }
    
    elseif($db->req2 == 'فعالیت صنعتی'){
        $sql = "select * from rents where type='$db->req2' and meterage='$bot->recmsg' and `status`='accepted'";
        $stmt = $db->conn->prepare($sql);
        $stmt->execute();
        $stmt->setFetchMode(PDO::FETCH_ASSOC);
        $getter = $stmt->fetchAll();
        if (count($getter) == 0) {
            $bot->sendmessage(urlencode('ملکی یافت نشد'), $bot->chatid, $bot->backKey);
            exit();
        } 
    
        foreach($getter as $singleGetter){
            $text="
کد ملک : $singleGetter[id]
متراژ : $singleGetter[meterage]
ملک : $singleGetter[type]
توضیحات: $singleGetter[description]
ابعاد محوطه : $singleGetter[mohavate]
ابعاد دفتر : $singleGetter[daftar]
امتیازات ملک : $singleGetter[emtiaz]
آدرس ملک : $singleGetter[address]
قیمت : $singleGetter[price]

برای مشاهده ی عکس های ملک بر روی مشاهده تصاویر کلیک کنید

برای ارتباط با ادمین به آیدی @amlaksalarii پیام بدهید
        ";
    
            if(empty($singleGetter['message_id1'])){
                $keys = json_encode(
                    array(
                        "inline_keyboard" => array(
                            array(array("callback_data" => urlencode("🔙 بازگشت"), "text" => urlencode("🔙 بازگشت"))),
                        )
                    )
                );
            } else {
                $keys = json_encode(
                    array(
                        "inline_keyboard" => array(
                            array(array("callback_data" => urlencode("showSellPicIndustrial_"."$singleGetter[id]"), "text" => urlencode("مشاهده تصاویر"))),
                            array(array("callback_data" => urlencode("🔙 بازگشت"), "text" => urlencode("🔙 بازگشت"))),
                        )
                    )
                );
            }

            $bot->sendmessage(urlencode($text), $bot->chatid, $keys);
        }
    }

    $sql = "update users set req1='' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
}

elseif(strpos($bot->recmsg,"showRentPicWarehouse_") !== false){
    $parts = explode('_', $bot->recmsg);
    $id = $parts[1]; 

    $result = $db->getRent($id);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id1']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id2']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id3']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id4']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id5']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id6']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id7']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id8']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id9']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id10']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id11']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id12']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id13']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id14']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id15']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id16']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id17']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id18']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id19']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id20']);

    $text = "کد ملک : $result[id]
برای ارتباط با ادمین به آیدی @amlaksalarii پیام بدهید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);
}

elseif(strpos($bot->recmsg,"showSellPicIndustrial_") !== false){
    $parts = explode('_', $bot->recmsg);
    $id = $parts[1]; 

    $result = $db->getRent($id);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id1']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id2']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id3']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id4']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id5']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id6']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id7']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id8']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id9']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id10']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id11']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id12']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id13']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id14']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id15']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id16']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id17']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id18']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id19']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id20']);

    $text = "کد ملک : $result[id]
برای ارتباط با ادمین به آیدی @amlaksalarii پیام بدهید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);
}

elseif($bot->recmsg == "request_purchase"){
    $keys = json_encode(
        array(
            "inline_keyboard" => array(
                array(
                    array(
                        "text" => urlencode("خارج از شهرک صنعتی"),
                        "callback_data" => urlencode("خارج از شهرک صنعتی")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("داخل شهرک صنعتی"),
                        "callback_data" => urlencode("داخل شهرک صنعتی")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("باغ و ویلا"),
                        "callback_data" => urlencode("باغ و ویلا")
                    )
                ),
                array(
                    array(
                        "text" => urlencode("🔙 بازگشت"),
                        "callback_data" => urlencode("🔙 بازگشت")
                    )
                )
            )
        )
    );
    
    $text = "گزینه ی مورد نظر خود را انتخاب کنید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

    $sql = "update users set req1='sellShowType', req2='' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
}

elseif($db->req1 == 'sellShowType'){
    if($bot->recmsg == "باغ و ویلا"){
        $text = "جهت خرید باغ و ویلا به آیدی @amlaksalarii پیام دهید.";
        $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);
        
        $sql = "update users set req1='' where chatid='" . $bot->chatid . "' ";
        $db->conn->exec($sql);
    } else {
        $keys = json_encode(
            array(
                "inline_keyboard" => array(
                    array(
                        array(
                            "text" => urlencode("کمتر از 200 متر"),
                            "callback_data" => urlencode("کمتر از 200 متر")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("200 الی 500 متر"),
                            "callback_data" => urlencode("200 الی 500 متر")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("500 متر به بالا"),
                            "callback_data" => urlencode("500 متر به بالا")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("زمین"),
                            "callback_data" => urlencode("زمین")
                        )
                    ),
                    array(
                        array(
                            "text" => urlencode("🔙 بازگشت"),
                            "callback_data" => urlencode("🔙 بازگشت")
                        )
                    )
                )
            )
        );
        
        $text = "گزینه ی مورد نظر خود را انتخاب کنید";
        $bot->sendmessage(urlencode($text), $bot->chatid, $keys);

        $sql = "update users set req1='sellShowMeterage', req2='$bot->recmsg' where chatid='" . $bot->chatid . "' ";
        $db->conn->exec($sql);
    }
}

elseif($db->req1 == 'sellShowMeterage'){
    $sql = "select * from sells where type='$db->req2' and meterage='$bot->recmsg' and `status`='accepted'";
    $stmt = $db->conn->prepare($sql);
    $stmt->execute();
    $stmt->setFetchMode(PDO::FETCH_ASSOC);
    $getter = $stmt->fetchAll();
    if (count($getter) == 0) {
        $bot->sendmessage(urlencode('ملکی یافت نشد'), $bot->chatid, $bot->backKey);
        exit();
    } 

    foreach($getter as $singleGetter){
        $text="
کد ملک : $singleGetter[id]
متراژ : $singleGetter[meterage]
ملک : $singleGetter[type]
توضیحات: $singleGetter[description]
ابعاد محوطه : $singleGetter[mohavate]
ابعاد دفتر : $singleGetter[daftar]
امتیازات ملک : $singleGetter[emtiaz]
آدرس ملک : $singleGetter[address]
قیمت : $singleGetter[price]
پایانکار : $singleGetter[payankar]

برای مشاهده ی عکس های ملک بر روی مشاهده تصاویر کلیک کنید

برای ارتباط با ادمین به آیدی @amlaksalarii پیام بدهید
    ";

        if(empty($singleGetter['message_id1'])){
            $keys = json_encode(
                array(
                    "inline_keyboard" => array(
                        array(array("callback_data" => urlencode("🔙 بازگشت"), "text" => urlencode("🔙 بازگشت"))),
                    )
                )
            );
        } else {
            $keys = json_encode(
                array(
                    "inline_keyboard" => array(
                        array(array("callback_data" => urlencode("showSellPic_"."$singleGetter[id]"), "text" => urlencode("مشاهده تصاویر"))),
                        array(array("callback_data" => urlencode("🔙 بازگشت"), "text" => urlencode("🔙 بازگشت"))),
                    )
                )
            );
        }

        $bot->sendmessage(urlencode($text), $bot->chatid, $keys);
    }

    $sql = "update users set req1='', req2='$bot->recmsg' where chatid='" . $bot->chatid . "' ";
    $db->conn->exec($sql);
}

elseif(strpos($bot->recmsg,"showSellPic_") !== false){
    $parts = explode('_', $bot->recmsg);
    $id = $parts[1]; 

     $result = $db->getSell($id);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id1']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id2']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id3']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id4']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id5']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id6']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id7']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id8']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id9']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id10']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id11']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id12']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id13']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id14']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id15']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id16']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id17']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id18']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id19']);
    $bot->copyMessage($bot->chatid, $result['chatid'], $result['message_id20']);

   
    $text = "کد ملک : $result[id]
برای ارتباط با ادمین به آیدی @amlaksalarii پیام بدهید";
    $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);
}

elseif($bot->recmsg == 'contact_us'){
    $text = "
برای ارتباط با ما با شماره های زیر تماس بگیرید

آتون :
شماره تماس : <code>09158041534</code>
آیدی : @At0on
جعفری پور 
شماره تماس : <code>09158838688</code>
آیدی : @Minisipi
نیکویی 
شماره تماس : <code>09157455026</code>
آیدی : @Ehsannik6973

با کلیک بر روی شماره مورد نظر آن را کپی کنید
";
    $bot->sendmessage(urlencode($text), $bot->chatid, $bot->backKey);
}
?>